;===== FlashSpacesGui =====
;Displays a small gui showing which space the user is moving to. Very similar to the mac. 
;test by uncommenting the following
flashSpacesGui(1,2)	;||
sleep 2000				;||
flashSpacesGuiOff()	;||
exitApp				;||


flashSpacesGui(curDesktopInput, newDesktopInput)
{
	global curDesktop = curDesktopInput
	global newDesktop = newDesktopInput
	global arrow := determineArrowDirection(curDesktop, newDesktop)

	Gui, +AlwaysOnTop -Caption ;+ToolWindow
	Gui, Color, 000000
	Gui, add, picture,   , % addSpaceImage(1)   ;%
	Gui, add, picture,   , % addSpaceImage(3)   ;%
	Gui, add, picture,ys , % addSpaceImage(2)   ;%
	Gui, add, picture,   , % addSpaceImage(4)   ;%
	Gui, show, , Spaces

	;===== Fullscreen screenshot display =====
	;could be used for a grand view of all spaces
	;could also be used for the transition animations
;	Gui 2: +AlwaysOnTop -Caption
;	Gui 2: add, picture, x0 y0 , screenshot.png	;there is a gray border that they x0 y0 positioning deals with
;	Gui 2: show
}

flashSpacesGuiOff()
{
	Gui, Destroy
}

	addSpaceImage(space)
	{
		global newDesktop
		global curDesktop
		global arrow
		
		if (space = newDesktop)
			image = newDesktop.png
		else if (space = curDesktop)
			image = %arrow%
		else image = inactiveDesktop.png
		;msgbox space: %space%, new: %newDesktop%, cur: %curDesktop%
		return image
	}

	determineArrowDirection(curDesktop, newDesktop)
	{
		diff := newDesktop - curDesktop
		if diff = 0
			msgbox This is the same desktop
		else if (diff = 1)	;1>2, (2>3), 3>4					right
			arrow = arrowRight.png
		else if diff = -1	;2>1, (3>2), 4>3
			arrow = arrowLeft.png
		else if (abs(diff) = 2)	;UP(3>1, 4>2) DOWN(1>3, 2>4)
		{
			if (curDesktop <= 2)
				arrow = arrowDown.png
			else if (curDesktop >= 3)
				arrow = arrowUp.png
			else msgbox we have a problem  :^(
		}
		else arrow = inactiveDesktop.png	;don't display an arrow
		return arrow
	}